// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     chrome/browser/ui/webui/omnibox/omnibox.mojom
//

package org.chromium.mojom;

class OmniboxUiHandlerMojo_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<OmniboxUiHandlerMojo, OmniboxUiHandlerMojo.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<OmniboxUiHandlerMojo, OmniboxUiHandlerMojo.Proxy>() {
    
        public String getName() {
            return "::OmniboxUIHandlerMojo";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, OmniboxUiHandlerMojo impl) {
            return new Stub(core, impl);
        }
    
        public OmniboxUiHandlerMojo[] buildArray(int size) {
          return new OmniboxUiHandlerMojo[size];
        }
    };

    private static final int START_OMNIBOX_QUERY_ORDINAL = 0;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements OmniboxUiHandlerMojo.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void startOmniboxQuery(String inputString, int cursorPosition, boolean preventInlineAutocomplete, boolean preferKeyword, int pageClassification, OmniboxPage page) {
            OmniboxUiHandlerMojoStartOmniboxQueryParams _message = new OmniboxUiHandlerMojoStartOmniboxQueryParams();
            _message.inputString = inputString;
            _message.cursorPosition = cursorPosition;
            _message.preventInlineAutocomplete = preventInlineAutocomplete;
            _message.preferKeyword = preferKeyword;
            _message.pageClassification = pageClassification;
            _message.page = page;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(START_OMNIBOX_QUERY_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<OmniboxUiHandlerMojo> {

        Stub(org.chromium.mojo.system.Core core, OmniboxUiHandlerMojo impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                OmniboxUiHandlerMojo_Internal.MANAGER, messageWithHeader);
                    case START_OMNIBOX_QUERY_ORDINAL: {
                        OmniboxUiHandlerMojoStartOmniboxQueryParams data =
                                OmniboxUiHandlerMojoStartOmniboxQueryParams.deserialize(messageWithHeader.getPayload());
                        getImpl().startOmniboxQuery(data.inputString, data.cursorPosition, data.preventInlineAutocomplete, data.preferKeyword, data.pageClassification, data.page);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), OmniboxUiHandlerMojo_Internal.MANAGER, messageWithHeader, receiver);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class OmniboxUiHandlerMojoStartOmniboxQueryParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 40;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(40, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String inputString;
        public int cursorPosition;
        public boolean preventInlineAutocomplete;
        public boolean preferKeyword;
        public int pageClassification;
        public OmniboxPage page;
    
        private OmniboxUiHandlerMojoStartOmniboxQueryParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public OmniboxUiHandlerMojoStartOmniboxQueryParams() {
            this(0);
        }
    
        public static OmniboxUiHandlerMojoStartOmniboxQueryParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static OmniboxUiHandlerMojoStartOmniboxQueryParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            OmniboxUiHandlerMojoStartOmniboxQueryParams result = new OmniboxUiHandlerMojoStartOmniboxQueryParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.inputString = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.cursorPosition = decoder0.readInt(16);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.preventInlineAutocomplete = decoder0.readBoolean(20, 0);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.preferKeyword = decoder0.readBoolean(20, 1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.pageClassification = decoder0.readInt(24);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.page = decoder0.readServiceInterface(28, false, OmniboxPage.MANAGER);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(inputString, 8, false);
            encoder0.encode(cursorPosition, 16);
            encoder0.encode(preventInlineAutocomplete, 20, 0);
            encoder0.encode(preferKeyword, 20, 1);
            encoder0.encode(pageClassification, 24);
            encoder0.encode(page, 28, false, OmniboxPage.MANAGER);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            OmniboxUiHandlerMojoStartOmniboxQueryParams other = (OmniboxUiHandlerMojoStartOmniboxQueryParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.inputString, other.inputString))
                return false;
            if (this.cursorPosition != other.cursorPosition)
                return false;
            if (this.preventInlineAutocomplete != other.preventInlineAutocomplete)
                return false;
            if (this.preferKeyword != other.preferKeyword)
                return false;
            if (this.pageClassification != other.pageClassification)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.page, other.page))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(inputString);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(cursorPosition);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(preventInlineAutocomplete);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(preferKeyword);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(pageClassification);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(page);
            return result;
        }
    }

}

